<?php
require __DIR__ . '/config/db.php';
require_once __DIR__ . '/lib/fpdf.php';

$pdo = getPDO();
$kode = $_GET['kode'] ?? '';

if (!$kode) {
    die("Kode agenda tidak ditemukan.");
}

// Ambil data agenda
$stmt = $pdo->prepare("SELECT * FROM agenda WHERE kode_agenda = ?");
$stmt->execute([$kode]);
$agenda = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$agenda) {
    die("Agenda tidak ditemukan.");
}

// Ambil daftar presensi
$stmt = $pdo->prepare("SELECT * FROM presensi WHERE kode_agenda = ? ORDER BY waktu_hadir ASC");
$stmt->execute([$kode]);
$presensi = $stmt->fetchAll(PDO::FETCH_ASSOC);

$pdf = new FPDF('P', 'mm', 'A4');
$pdf->AddPage();

// === Gambar Kop Surat ===
$kopPath = __DIR__ . '/assets/img/kop.png'; // ganti sesuai lokasi kamu
if (file_exists($kopPath)) {
    // tampilkan kop surat (lebar penuh)
    $pdf->Image($kopPath, 10, 8, 190);
    $pdf->Ln(35); // beri jarak setelah kop
} else {
    // fallback teks kop kalau gambar belum ada
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(0, 6, 'INSTITUT AGAMA HINDU NEGERI GDE PUJA MATARAM', 0, 1, 'C');
    $pdf->Cell(0, 6, 'Jl. Pancaka No.7, Mataram – Telp. (0370) xxxx', 0, 1, 'C');
    $pdf->Ln(8);
}

// === Judul ===
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 8, 'DAFTAR HADIR RAPAT / KEGIATAN', 0, 1, 'C');
$pdf->Ln(6);

// === Detail Agenda ===
$pdf->SetFont('Arial', '', 11);
$pdf->Cell(40, 6, 'Judul', 0, 0);
$pdf->Cell(0, 6, ': ' . $agenda['judul'], 0, 1);
$pdf->Cell(40, 6, 'Tanggal', 0, 0);
$pdf->Cell(0, 6, ': ' . $agenda['tanggal'], 0, 1);
$pdf->Cell(40, 6, 'Waktu', 0, 0);
$pdf->Cell(0, 6, ': ' . $agenda['waktu_mulai'] . ' - ' . $agenda['waktu_selesai'], 0, 1);
$pdf->Cell(40, 6, 'Tempat', 0, 0);
$pdf->Cell(0, 6, ': ' . ($agenda['tempat'] ?: '-'), 0, 1);
$pdf->Ln(8);

// === Tabel Presensi ===
$pdf->SetFont('Arial', 'B', 11);
$pdf->Cell(10, 8, 'No', 1, 0, 'C');
$pdf->Cell(80, 8, 'Nama Peserta', 1, 0, 'C');
$pdf->Cell(50, 8, 'Waktu Hadir', 1, 0, 'C');
$pdf->Cell(50, 8, 'Tanda Tangan', 1, 1, 'C');

$pdf->SetFont('Arial', '', 10);
$no = 1;

foreach ($presensi as $p) {
    $pdf->Cell(10, 20, $no++, 1, 0, 'C');
    $pdf->Cell(80, 20, $p['nama_peserta'], 1, 0);
    $pdf->Cell(50, 20, $p['waktu_hadir'], 1, 0, 'C');

    $imgData = $p['tanda_tangan'];
    if (strpos($imgData, 'data:image') === 0) {
        $img = str_replace('data:image/png;base64,', '', $imgData);
        $img = str_replace(' ', '+', $img);
        $file = tempnam(sys_get_temp_dir(), 'sig') . '.png';
        file_put_contents($file, base64_decode($img));
        $x = $pdf->GetX();
        $y = $pdf->GetY();
        $pdf->Cell(50, 20, '', 1, 1, 'C');
        $pdf->Image($file, $x + 10, $y + 2, 30, 15);
        unlink($file);
    } else {
        $pdf->Cell(50, 20, '-', 1, 1, 'C');
    }
}

$pdf->Output('I', 'rekap-presensi-' . $agenda['kode_agenda'] . '.pdf');
