<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require __DIR__ . '/config/db.php';

$pdo = getPDO();
$kode = $_GET['kode'] ?? '';

if (!$kode) {
    die("<h3>Kode agenda tidak ditemukan.</h3>");
}

// Ambil detail agenda
$stmt = $pdo->prepare("SELECT * FROM agenda WHERE kode_agenda = ?");
$stmt->execute([$kode]);
$agenda = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$agenda) {
    die("<h3>Agenda tidak ditemukan.</h3>");
}

// Ambil daftar presensi
$stmt = $pdo->prepare("SELECT * FROM presensi WHERE kode_agenda = ? ORDER BY waktu_hadir ASC");
$stmt->execute([$kode]);
$presensi = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Rekap Presensi - <?= htmlspecialchars($agenda['judul']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .signature {
            border: 1px solid #ddd;
            border-radius: 4px;
            background-color: #f8f9fa;
            padding: 4px;
            max-height: 100px;
        }
        .signature img {
            width: 100%;
            max-height: 80px;
            object-fit: contain;
        }
    </style>
</head>
<body class="bg-light">
<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4>📋 Rekap Presensi</h4>
        <a href="agenda.php" class="btn btn-secondary btn-sm">⬅ Kembali</a>
    </div>

    <div class="card p-3 mb-4">
        <h5><?= htmlspecialchars($agenda['judul']) ?></h5>
        <p class="mb-1"><strong>Tanggal:</strong> <?= htmlspecialchars($agenda['tanggal']) ?></p>
        <p class="mb-1"><strong>Waktu:</strong> <?= htmlspecialchars($agenda['waktu_mulai']) ?> - <?= htmlspecialchars($agenda['waktu_selesai']) ?></p>
        <p class="mb-1"><strong>Tempat:</strong> <?= htmlspecialchars($agenda['tempat'] ?: '-') ?></p>
        <p class="mb-0"><strong>Penyelenggara:</strong> <?= htmlspecialchars($agenda['penyelenggara'] ?: '-') ?></p>
    </div>

    <div class="card p-3">
        <h5 class="mb-3">Daftar Hadir Peserta</h5>
        
        <a href="rekap_pdf.php?kode=<?= urlencode($kode) ?>" target="_blank" class="btn btn-danger btn-sm mb-3">🖨️ Cetak PDF</a>


        <?php if (count($presensi) > 0): ?>
            <table class="table table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th width="5%">No</th>
                        <th>Nama Peserta</th>
                        <th width="20%">Waktu Hadir</th>
                        <th width="30%">Tanda Tangan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($presensi as $i => $p): ?>
                        <tr>
                            <td><?= $i + 1 ?></td>
                            <td><?= htmlspecialchars($p['nama_peserta']) ?></td>
                            <td><?= htmlspecialchars($p['waktu_hadir']) ?></td>
                            <td class="signature">
                                <img src="<?= htmlspecialchars($p['tanda_tangan']) ?>" alt="Tanda Tangan">
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="alert alert-warning">Belum ada peserta yang mengisi presensi.</div>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
