<?php
require __DIR__ . '/config/db.php';
$pdo = getPDO();

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nama = trim($_POST['nama']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $role = $_POST['role'];

    if ($nama && $email && $password) {
        // Hash password agar cocok dengan password_verify()
        $hashed = password_hash($password, PASSWORD_DEFAULT);

        $stmt = $pdo->prepare("INSERT INTO users (nama, email, password, role) VALUES (?, ?, ?, ?)");
        if ($stmt->execute([$nama, $email, $hashed, $role])) {
            $message = '<div class="alert alert-success">✅ User berhasil ditambahkan!</div>';
        } else {
            $message = '<div class="alert alert-danger">❌ Gagal menambahkan user. Mungkin email sudah digunakan.</div>';
        }
    } else {
        $message = '<div class="alert alert-warning">⚠️ Semua field wajib diisi.</div>';
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Tambah User - Portal Agenda</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f7f9fc; }
        .container { max-width: 500px; margin-top: 60px; }
        .card { border-radius: 14px; box-shadow: 0 0 10px rgba(0,0,0,0.08); }
    </style>
</head>
<body>
<div class="container">
    <div class="card p-4">
        <h4 class="mb-3 text-primary text-center">👤 Tambah User</h4>
        <?= $message ?>
        <form method="POST">
            <div class="mb-3">
                <label class="form-label">Nama Lengkap</label>
                <input type="text" name="nama" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Email</label>
                <input type="email" name="email" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Password</label>
                <input type="password" name="password" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Role</label>
                <select name="role" class="form-select">
                    <option value="user">User</option>
                    <option value="admin">Admin</option>
                </select>
            </div>
            <button type="submit" class="btn btn-primary w-100">💾 Simpan User</button>
        </form>
        <div class="text-center mt-3">
            <a href="index.php" class="text-secondary">← Kembali ke Login</a>
        </div>
    </div>
</div>
</body>
</html>
