<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Dashboard - Portal Agenda</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: #f7f9fc; }
        .menu-card { border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); transition: 0.2s; }
        .menu-card:hover { transform: scale(1.03); }
    </style>
</head>
<body>
<div class="container py-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3>👋 Selamat datang, <?= htmlspecialchars($_SESSION['nama']) ?></h3>
        <a href="logout.php" class="btn btn-outline-danger">Keluar</a>
    </div>

    <div class="row g-4">
        <!-- Menu Agenda -->
        <div class="col-md-4">
            <a href="agenda.php" class="text-decoration-none text-dark">
                <div class="card menu-card p-4 text-center">
                    <h4>📅 Agenda</h4>
                    <p class="text-muted">Kelola jadwal rapat dan kegiatan</p>
                </div>
            </a>
        </div>

        <!-- Menu Presensi (nanti bisa ditambah) -->
        <div class="col-md-4">
            <a href="#" class="text-decoration-none text-dark">
                <div class="card menu-card p-4 text-center">
                    <h4>🧾 Presensi</h4>
                    <p class="text-muted">Daftar hadir peserta kegiatan</p>
                </div>
            </a>
        </div>

        <!-- Menu Notulensi (nanti juga bisa) -->
        <div class="col-md-4">
            <a href="#" class="text-decoration-none text-dark">
                <div class="card menu-card p-4 text-center">
                    <h4>📝 Notulensi</h4>
                    <p class="text-muted">Catatan hasil rapat dan tindak lanjut</p>
                </div>
            </a>
        </div>
    </div>
</div>
</body>
</html>
